/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VWFieldTypeRenderer
extends DefaultTableCellRenderer {
    public static String typeToString(int type, boolean bArray) {
        String string = null;
        try {
            string = VWFieldType.getLocalizedString(type);
        }
        catch (VWException ex) {
            switch (type) {
                case 32: {
                    string = VWResource.s_attachment;
                    break;
                }
                case 4: {
                    string = VWResource.s_boolean;
                    break;
                }
                case 8: {
                    string = VWResource.s_float;
                    break;
                }
                case 1: {
                    string = VWResource.s_integer;
                    break;
                }
                case 64: {
                    string = VWResource.s_workflowGroup;
                    break;
                }
                case 2: {
                    string = VWResource.s_string;
                    break;
                }
                case 16: {
                    string = VWResource.s_date;
                    break;
                }
                case 128: {
                    string = VWResource.s_xml;
                }
            }
        }
        if (bArray) {
            string = string + "[]";
        }
        return string;
    }

    public int getMaxWidth() {
        return this.getMaxWidth(767);
    }

    public int getMaxWidth(int types) {
        FontMetrics fm;
        int mask = 1;
        int width = 0;
        Font font = this.getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            for (mask = 1; mask != 0; mask <<= 1) {
                int w = 0;
                int type = mask & types;
                if (type != 0) {
                    w = fm.stringWidth(VWFieldTypeRenderer.typeToString(type, true));
                }
                if (width >= w) continue;
                width = w;
            }
        }
        return width;
    }

    public int getMaxWidth(boolean bBasicOnly) {
        if (bBasicOnly) {
            return this.getMaxWidth(31);
        }
        return this.getMaxWidth(767);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        component.setComponentOrientation(compOrientation);
        String text = null;
        if (value != null && value instanceof Integer) {
            boolean bArray = false;
            int type = (Integer)value;
            if ((type & 0x800) != 0) {
                type &= 0x7FF;
                bArray = true;
            }
            text = VWFieldTypeRenderer.typeToString(type, bArray);
        }
        ((JLabel)component).setText(text);
        ((JLabel)component).setToolTipText(text);
        return component;
    }
}

